<!-- Copyright © SixtyFPS GmbH <info@slint.dev> ; SPDX-License-Identifier: CC-BY-ND-4.0 -->

# Brand Guidelines

## Name

The name of the product is ***Slint***, not ~~*Slint UI*~~.

`slint-ui` or `slint_ui` is used as username for online service when (and only when) `slint` is already taken.

The company (legal entity) behind Slint is *SixtyFPS GmbH*. That name should only be used to refer to the company,
including the *GmbH*. (*SixtyFPS* was the former name of the product but should no longer be used.)
Employees of SixtyFPS GmbH should still use the name *Slint* whenever possible (e.g. on conference badges).

## Color

The Slint blue color is:

* For Screen: #2379F4 (Hex), R=35 G=121 B=244, Tint = 100,
* For Print: CMYK = 75,45,0,0,
* For Spot Color (Pantone): PMS 2727 C.

## Logo

* The logos are licensed under [Creative Commons Attribution-NoDerivatives 4.0 International License](http://creativecommons.org/licenses/by-nd/4.0/).
   ![CC-BY-ND-4.0](https://i.creativecommons.org/l/by-nd/4.0/88x31.png)

* Do not modify the logo by changing the colors, changing of the aspect ration,
   or other alterations to the corporate identity.

* When using the logo to refer to Slint from a location not dedicated to Slint,
   use the full versions of the logo with the full tagline ("GUI toolkit").

   ![Slint logo full light](./slint-logo-full-light.svg#gh-light-mode-only)![Slint logo full dark](./slint-logo-full-dark.svg#gh-dark-mode-only)

* When using the logo to refer to Slint for illustrative purposes, from a place
   where the viewer is expected to already know about Slint (e.g. because it is
   on the Slint website itself) use the simple versions of the logo.

   ![Slint logo simple light](./slint-logo-simple-light.svg#gh-light-mode-only)![Slint logo simple dark](./slint-logo-simple-dark.svg#gh-dark-mode-only)

* For the cases where a square or circular logo is required (e.g. social media
   avatar), the square versions of the logo can be used. Prefer the version with
   the text.

   ![Slint logo square light](./slint-logo-square-light.svg#gh-light-mode-only)![Slint logo square dark](./slint-logo-square-dark.svg#gh-dark-mode-only)

* For a small icon where the text would not be visible otherwise, use the square
   versions of the logo without the text.

   ![Slint logo small light](./slint-logo-small-light.svg#gh-light-mode-only)![Slint logo small dark](./slint-logo-small-dark.svg#gh-dark-mode-only)

* Use the #MadeWithSlint logo for attributions to Slint (e.g. when using Slint under the [Royalty-Free License](../LICENSES/LicenseRef-Slint-Royalty-free-1.1.md)).

   ![#MadeWithSlint logo light](./MadeWithSlint-logo-light.svg#gh-light-mode-only)![#MadeWithSlint logo dark](./MadeWithSlint-logo-dark.svg#gh-dark-mode-only)

### Variations (Dark mode, Light mode)

* For Dark mode/backgrounds, use the versions with ***dark***.

* For Light mode/backgrounds, use the versions with ***light***.

* If the background switched between dark and light mode, but only one logo can be shown, use the versions with ***whitebg***.
